////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <UIKit/UIKit.h>

// Pin Interface
#import <MSSOrchestration/PinDigitsView.h>

// Authentication
#import <MSSOrchestration/UserAuthenticationDelegate.h>
#import <MSSOrchestration/UserAuthenticationInputDelegate.h>

// CDDC
#import <MSSOrchestration/CDDCDataFeederProtocol.h>
#import <MSSOrchestration/CDDCMessageParams.h>
#import <MSSOrchestration/CDDCParams.h>

// User
#import <MSSOrchestration/UserInformationProtocol.h>
#import <MSSOrchestration/UserManagerProtocol.h>
#import <MSSOrchestration/OrchestrationUser.h>
#import <MSSOrchestration/OrchestrationAccessGroup.h>

// Error
#import <MSSOrchestration/OrchestrationError.h>
#import <MSSOrchestration/OrchestrationErrorCodes.h>
#import <MSSOrchestration/OrchestrationErrorDelegate.h>
#import <MSSOrchestration/OrchestrationServerError.h>
#import <MSSOrchestration/OrchestrationWarning.h>
#import <MSSOrchestration/OrchestrationWarningCodes.h>
#import <MSSOrchestration/OrchestrationWarningDelegate.h>

// Exception
#import <MSSOrchestration/OrchestrationException.h>
#import <MSSOrchestration/ActivationInputException.h>
#import <MSSOrchestration/PasswordException.h>
#import <MSSOrchestration/InputException.h>

// Flows
#import <MSSOrchestration/CryptoAppIndex.h>
#import <MSSOrchestration/PasswordError.h>
#import <MSSOrchestration/InputError.h>
#import <MSSOrchestration/ProtectionType.h>

// Flows/Activation
#import <MSSOrchestration/ActivationDelegate.h>
#import <MSSOrchestration/ActivationInputError.h>
#import <MSSOrchestration/ActivationParams.h>

// Flows/Activation/Online
#import <MSSOrchestration/OnlineActivationDelegate.h>
#import <MSSOrchestration/OnlineActivationInputError.h>
#import <MSSOrchestration/OnlineActivationParams.h>

// Flows/ChangePassword
#import <MSSOrchestration/ChangePasswordDelegate.h>
#import <MSSOrchestration/ChangePasswordParams.h>

// Flows/LocalAuthentication
#import <MSSOrchestration/LocalAuthenticationParams.h>
#import <MSSOrchestration/LocalAuthenticationDelegate.h>

// Flows/LocalTransaction
#import <MSSOrchestration/LocalTransactionDelegate.h>
#import <MSSOrchestration/LocalTransactionParams.h>

// Flows/Notification
#import <MSSOrchestration/NotificationRegistrationDelegate.h>
#import <MSSOrchestration/NotificationRegistrationParams.h>

// Flows/RemoteAuth
#import <MSSOrchestration/RemoteAuthenticationDelegate.h>
#import <MSSOrchestration/RemoteAuthenticationDisplayDataCallerDelegate.h>

// Flows/RemoteTransaction
#import <MSSOrchestration/RemoteTransactionDelegate.h>
#import <MSSOrchestration/RemoteTransactionDisplayDataCallerDelegate.h>

// Orchestration
#import <MSSOrchestration/OrchestrationProtocol.h>
#import <MSSOrchestration/OrchestratorBuilder.h>

#define OrchestrationSDK_VERSION  @"5.12.0"

//! Project version number for MSSOrchestration.
FOUNDATION_EXPORT double MSSOrchestrationVersionNumber;

//! Project version string for MSSOrchestration.
FOUNDATION_EXPORT const unsigned char MSSOrchestrationVersionString[];

/*!
 * \mainpage Orchestration SDK - Programmer documentation
 * \brief This documentation describes the methods and the constants provided by the Orchestration SDK.<br/>
 * <br/>
 * @OneSpanCopyright
 * \version 5.12.0
 */
